;;; - ------------------------------------------------------------------------------ - ;
;;; -                 T O O L - K_VP-ROTATE                                          - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - Beschreibung :  Inhalt von Ansichtsfenster drehen                              - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - Befehle      :  K_vp-rotate                                                    - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - letzte nderung am : 08.10.2022                                                - ;
;;; -              durch : Andreas Kraus                                             - ;
;;; - ------------------------------------------------------------------------------ - ;

(vl-load-com)
(DEFUN K_3D->2D	(WERT / DUMMY)
  (IF (VL-EVERY	(QUOTE (LAMBDA (DUMMY) (= (TYPE DUMMY) (QUOTE LIST))))
		WERT
      )
    (MAPCAR (QUOTE (LAMBDA (DUMMY) (LIST (CAR DUMMY) (CADR DUMMY))))
	    WERT
    )
    (LIST (CAR WERT) (CADR WERT))
  )
)

(DEFUN K_AC-DOC	nil
  (vla-get-ActiveDocument (vlax-get-acad-object))
)

(DEFUN K_P_TWIST (P PX WX)
  (SETQ	PZ  (CADDR P)
	PXZ (CADDR PX)
  )
  (SETQ	P  (K_3D->2D P)
	PX (K_3D->2D PX)
  )
  (VL-REMOVE (QUOTE nil)
	     (APPEND (POLAR PX (+ (ANGLE PX P) WX) (DISTANCE PX P))
		     (LIST PZ)
	     )
  )
)

(DEFUN K_SATZ->ENTLIST (SATZ)
  (IF (= (TYPE SATZ) (QUOTE PICKSET))
    (VL-REMOVE-IF-NOT
      (QUOTE (LAMBDA (DUMMY) (= (TYPE DUMMY) (QUOTE ENAME))))
      (MAPCAR (QUOTE CADR) (SSNAMEX SATZ))
    )
  )
)

(DEFUN K_SSGET (TEXT ARGLIST / SATZ)
  (IF TEXT
    (PROGN
      (K_SAVE_VAR "NOMUTT")
      (PRINC (STRCAT " " TEXT))
      (SETVAR "NOMUTT" 1)
    )
  )
  (VL-CATCH-ALL-APPLY
    (LIST (QUOTE LAMBDA)
	  (QUOTE nil)
	  (QUOTE (SETQ SATZ (APPLY (QUOTE SSGET) ARGLIST)))
    )
  )
  (IF TEXT
    (K_RESTORE_VAR "NOMUTT")
  )
  SATZ
)

(defun c:k_vp-rotate (/	DX ENT_DATA FAKTOR MITTE PX PX_VIEW SATZ VPORT_NR WINKEL WINKEL_1 WINKEL_2 WINKEL_RAD)
;;; Ansicht drehen
  (vla-startundomark (k_ac-doc))
  (if (= (getvar "tilemode") 0)
    (progn
      (command "_.pspace")
;;;      (setq satz (ssget '((0 . "VIEWPORT"))))
      (if (setq	satz (k_ssget "Ansichtsfenster whlen : "
			      '(((0 . "VIEWPORT")))
		     )
	  )
	(progn
	  (command "_.mspace")
	  (setq	px	 (getpoint "Drehpunkt : ")
		winkel_1 (getangle "Startwinkel : ")
		winkel_2 (getangle "Endwinkel : ")
	  )
	  (if (and winkel_1 winkel_2)
	    (setq winkel_rad (- winkel_2 winkel_1))
	    (setq winkel_rad (- 0.0 (getvar "viewtwist")))
	  )
	  (cond
	    ((= (getvar "aunits") 0)
	     (setq winkel (* 180.0 (/ winkel_rad pi)))
	    )
	    ((= (getvar "aunits") 2)
	     (setq winkel (* 200.0 (/ winkel_rad pi)))
	    )
	    ((= (getvar "aunits") 3)
	     (setq winkel winkel_rad)
	    )
	  )
	  (foreach ent_name (k_satz->entlist satz)
	    (setq ent_data (entget ent_name)
		  vport_nr (cdr (assoc 69 ent_data))
	    )
	    (setvar "cvport" vport_nr)
	    (command "_.ucs" "_delete" "k_vp-rotate")
	    (command "_.ucs" "_save" "k_vp-rotate")
	    (command "_.ucs" "_view")
	    (setq mitte (getvar "viewctr"))
	    (setq faktor (getvar "viewsize"))
	    (if	px
	      (setq px_view (trans px 0 1))
	      (setq px_view (getvar "viewctr"))
	    )
	    (setq dx (k_p_twist px_view mitte (- 0 winkel_rad)))
	    (command "_.ucs" "_z" (- 0 winkel))
	    (command "_.plan" "")
	    (command "_.ucs" "_Previous")
	    (command "_.zoom" "_c" mitte faktor)
	    (command "_.zoom"
		     "_c"
		     (mapcar '- mitte (mapcar '- dx px_view))
		     faktor
	    )
	    (command "_.ucs" "_restore" "k_vp-rotate")
	  )
	  (command "_.ucs" "_delete" "k_vp-rotate")
	  (command "_.pspace")
	)
	(alert "Bitte ein Ansichtsfenster whlen")
      )
    )
    (progn
      (setq mitte    (getvar "viewctr")
	    faktor   (getvar "viewsize")
	    winkel_1 (getangle "Startwinkel : ")
	    winkel_2 (getangle "Endwinkel : ")
      )
      (if (and winkel_1 winkel_2)
	(setq winkel_rad (- winkel_2 winkel_1))
	(setq winkel_rad 0.0)
      )
      (cond
	((= (getvar "aunits") 0)
	 (setq winkel (* -180.0 (/ winkel_rad pi)))
	)
	((= (getvar "aunits") 2)
	 (setq winkel (* -200.0 (/ winkel_rad pi)))
	)
	((= (getvar "aunits") 3)
	 (setq winkel (* -1.0 winkel_rad))
	)
      )
      (command "_.ucs" "_z" winkel)
      (command "_.plan" "")
      (command "_.ucs" "_Previous")
      (command "_.zoom" "_c" mitte faktor)
    )
  )
  (vla-endundomark (k_ac-doc))
)
;;; - ------------------------------------------------------------------------------ - ;
(princ
  (strcat
    "\nK_vp-rotate:  Inhalt von Ansichtsfenster drehen"
    "\n===========  "
    "\n(C) Andreas Kraus 2022 (info@kraus-cad.de)"
    "\nBefehlszeilenaufruf : K_vp-rotate\n"
  )
)
;;; - ------------------------------------------------------------------------------ - ;
(princ)